# How to Restore Your Wadsworth AI PC

Your computer came with a "Factory Fresh" snapshot — a saved copy of exactly how it was when you first got it. If something goes wrong, you can restore to this snapshot and your computer will work like new again.

**This is a normal, safe thing to do.** It's like pressing a reset button.

---

## When Restoring Helps

Restoring is a good idea if:

- Your computer is acting strange after you installed something
- You accidentally changed system settings and can't fix them
- Programs that used to work suddenly don't
- You just want to start fresh

---

## When Restoring Won't Help

Try something else if:

- **Your computer is slow** — Try restarting first (Menu → Power → Restart)
- **You can't find a file** — Restoring won't bring back lost files
- **Something physical is broken** — Screen, keyboard, or battery problems need repair, not restore
- **Wi-Fi won't connect** — This is usually a settings issue, not something restore fixes

---

## Before You Restore: Important!

**Restoring takes your computer back in time.** This means:

- Any programs you installed after the snapshot will be removed
- Any settings you changed will be reset
- **Files you created or saved may be lost**

### Save Your Important Files First

Before restoring, copy anything important to a USB drive or cloud storage:

- Documents you've written
- Photos you've downloaded
- Anything in your Downloads folder you want to keep

**Take a moment.** Once you restore, you can't undo it.

---

## How to Restore (Step by Step)

### Step 1: Open Timeshift

1. Click the **Menu** button (bottom-left corner, like the Windows Start menu)
2. Type **Timeshift** in the search box
3. Click **Timeshift** when it appears
4. If asked for your password, type it and press Enter

### Step 2: Find the Factory Fresh Snapshot

1. You'll see a list of snapshots (saved copies of your system)
2. Look for the one labeled **"Factory Fresh"**
3. Click on it once to select it (it will be highlighted)

### Step 3: Start the Restore

1. Click the **Restore** button at the top
2. A window will appear asking you to confirm
3. Read the information, then click **Next**
4. On the next screen, leave the default options and click **Next**
5. Click **Next** one more time to confirm

### Step 4: Wait for It to Finish

1. The restore process will begin
2. **This takes several minutes** — don't turn off your computer
3. When finished, your computer will restart automatically

### Step 5: You're Done!

After the restart:

- Your computer will be back to its "Factory Fresh" state
- Log in with your username and password
- Everything will work like the day you got it

---

## After Restoring

Your computer is now reset. Here's what to expect:

- **Apps you added are gone** — You'll need to re-install them
- **Settings you changed are reset** — Wi-Fi password, wallpaper, etc.
- **Your files may be gone** — Anything created after the snapshot

This is normal! Your computer is simply back to how it was on day one.

---

## When to Contact Support Instead

Don't restore if you're unsure. Contact us first if:

- You're not sure if restoring will help
- You need help saving your files before restoring
- You already tried restoring and the problem came back
- You're nervous about doing this yourself

We're happy to walk you through it or do it for you in a support session.

---

## Still Have Questions?

- **Welcome Center** — More guides on your Desktop
- **Remote Support** — We can help via RustDesk (you control the session)

*Restoring is safe and normal. It's there to help you, not scare you!*
