# Moving Your Files to Your New Wadsworth AI PC

Switching from your old Windows computer? This guide helps you bring your important files with you — documents, photos, music, and more.

**Time needed:** About 30-60 minutes, depending on how much you're transferring.

---

## What You Can Transfer

These files work great on Linux Mint:

- **Documents** — Word files, PDFs, text files, spreadsheets
- **Photos** — JPG, PNG, and other image files
- **Music** — MP3, WAV, and other audio files
- **Videos** — MP4, AVI, and other video files
- **Downloads** — Anything you've downloaded
- **Browser bookmarks** — Your saved websites

---

## What You Don't Need to Transfer

Leave these behind — they won't work or aren't needed:

- **Windows programs (.exe files)** — They don't run on Linux
- **Program settings** — You'll set up apps fresh on your new computer
- **Windows system files** — Linux doesn't use them
- **Microsoft Office files you don't need** — Only bring documents you actually want

**Good news:** Your files (documents, photos, music) are separate from your programs. The files come with you — you just need new programs to open them (and Linux Mint has those already installed).

---

## Method 1: USB Drive (Recommended)

This is the most reliable way to transfer files. You'll need a USB flash drive.

### What Size USB Drive?

- **16GB** — Good for documents and some photos
- **32GB** — Good for most people
- **64GB or larger** — If you have lots of photos, music, or videos

*You can buy a USB drive at any electronics store, supermarket, or online for $10-20.*

### Step 1: Find Your Files on Windows

On your old Windows computer, open **File Explorer** (the folder icon) and look in these places:

- **Documents** — Usually at `C:\Users\YourName\Documents`
- **Pictures** — Usually at `C:\Users\YourName\Pictures`
- **Music** — Usually at `C:\Users\YourName\Music`
- **Videos** — Usually at `C:\Users\YourName\Videos`
- **Downloads** — Usually at `C:\Users\YourName\Downloads`
- **Desktop** — Files saved on your desktop

### Step 2: Copy Files to USB Drive

1. Plug your USB drive into your old Windows computer
2. Open File Explorer and find your USB drive (usually shows up as "D:" or "E:")
3. Create folders on the USB drive: Documents, Pictures, Music, etc.
4. Go back to each folder (Documents, Pictures, etc.)
5. Select files: Click one file, then press **Ctrl+A** to select all
6. Right-click and choose **Copy**
7. Go to the matching folder on your USB drive
8. Right-click and choose **Paste**
9. Wait for copying to finish (progress bar will show)
10. Repeat for each folder you want to transfer

### Step 3: Safely Remove USB from Windows

1. Look for the USB icon in the bottom-right corner of Windows
2. Click it and choose "Safely Remove" or "Eject"
3. Wait for the "Safe to remove" message
4. Unplug the USB drive

### Step 4: Copy Files to Your New Computer

1. Plug the USB drive into your Wadsworth AI PC
2. A window should pop up showing your USB drive (if not, click the folder icon in your taskbar)
3. Open your **Home** folder (click the folder icon, then click "Home" on the left)
4. You'll see folders: Documents, Pictures, Music, Videos, Downloads
5. Open the USB drive in a separate window
6. Drag files from the USB drive to the matching folders in your Home folder
7. Wait for copying to finish

### Step 5: Safely Remove USB from Linux

1. In the file manager, right-click on your USB drive (in the left sidebar)
2. Click "Eject" or "Safely Remove"
3. Wait a moment, then unplug

**You're done!** Your files are now on your new computer.

---

## Method 2: Cloud Storage (Alternative)

If you already use cloud storage, this can be easy. No USB drive needed.

### Services That Work

- **Google Drive** — drive.google.com
- **Dropbox** — dropbox.com
- **OneDrive** — onedrive.com (Microsoft's cloud storage)
- **iCloud** — icloud.com (if you use Apple devices too)

### How to Transfer via Cloud

**On your old Windows computer:**

1. Open your cloud storage website in a browser
2. Log in to your account
3. Upload the files you want to transfer
4. Wait for uploads to complete (this can take a while on slow internet)

**On your new Wadsworth AI PC:**

1. Open Firefox (or Chromium)
2. Go to the same cloud storage website
3. Log in to your account
4. Download your files
5. Move them from Downloads to the right folders (Documents, Pictures, etc.)

---

## Transferring Browser Bookmarks

Don't lose your favorite websites! Here's how to bring your bookmarks.

### From Chrome (on Windows)

1. Open Chrome
2. Click the three dots (top-right) → **Bookmarks** → **Bookmark Manager**
3. Click the three dots in Bookmark Manager → **Export bookmarks**
4. Save the file to your USB drive or cloud storage

### From Edge (on Windows)

1. Open Edge
2. Click the three dots (top-right) → **Favorites** → **Manage Favorites**
3. Click the three dots → **Export favorites**
4. Save the file to your USB drive or cloud storage

### From Firefox (on Windows)

1. Open Firefox
2. Click the menu (three lines) → **Bookmarks** → **Manage Bookmarks**
3. Click **Import and Backup** → **Export Bookmarks to HTML**
4. Save the file to your USB drive or cloud storage

### Import to Firefox (on Linux Mint)

1. Open Firefox on your new computer
2. Click the menu (three lines) → **Bookmarks** → **Manage Bookmarks**
3. Click **Import and Backup** → **Import Bookmarks from HTML**
4. Find and select your bookmarks file
5. Done! Your bookmarks are now in Firefox.

---

## What About Email?

### Web-Based Email (Gmail, Outlook.com, Yahoo)

**Nothing to transfer!** Just open Firefox, go to your email website, and log in. All your emails are already there in the cloud.

### Desktop Email Apps (Outlook, Windows Mail)

If you used a desktop email program on Windows, you'll now access your email through the web instead:

- **Gmail** → Go to gmail.com
- **Outlook/Hotmail** → Go to outlook.com
- **Yahoo** → Go to mail.yahoo.com

This is actually easier — your email is available from any device, anywhere.

---

## Helpful Tips

### Before You Start

- **Clean up first** — Delete files you don't need. Less to transfer!
- **Make a list** — Write down what's important so you don't forget anything
- **Check your Downloads folder** — It often has stuff you forgot about

### While Transferring

- **Take breaks** — It's okay to do this over a few sessions
- **Organize as you go** — Put files in the right folders instead of dumping everything in one place
- **Don't rush** — It's better to do it right than to do it fast

### Don't Panic About

- **Leaving programs behind** — Linux Mint has great alternatives already installed
- **Old files you're not sure about** — If you haven't opened it in years, you probably don't need it
- **Perfect organization** — You can always reorganize later

---

## Need Help?

- **Welcome Center** — More guides on your Desktop
- **Remote Support** — We can help you transfer files in a support session

*Moving your files is easier than it looks. Take your time, and soon you'll be right at home on your new computer!*
