#!/bin/bash
# open-chromium.sh - Wrapper to handle different Chromium package names
# Some systems have 'chromium-browser', others have 'chromium'

if command -v chromium-browser &>/dev/null; then
    exec chromium-browser "$@"
elif command -v chromium &>/dev/null; then
    exec chromium "$@"
else
    # Fallback: show error via zenity if available, otherwise terminal
    if command -v zenity &>/dev/null; then
        zenity --error --title="Chromium Not Found" \
            --text="Chromium is not installed.\n\nInstall it from Software Manager:\nMenu → Software Manager → search 'chromium'"
    else
        echo "Error: Chromium is not installed." >&2
        echo "Install it from Software Manager: Menu → Software Manager → search 'chromium'" >&2
    fi
    exit 1
fi
