# Wadsworth AI PCs

A production-ready refurbished laptop build pipeline using Linux Mint Cinnamon with golden images and first-boot automation.

## Quick Start

1. Read `AGENTS.md` to understand the workflow
2. Read `REQUIREMENTS.md` for product specification
3. Check `TODO.md` for current tasks
4. See `SKILLS.md` for Linux Mint technical patterns

## Project Structure

```
├── AGENTS.md              # Agent roles (Tech Lead + Claude Code)
├── SKILLS.md              # Linux Mint technical knowledge
├── TODO.md                # Task backlog with priorities
├── REQUIREMENTS.md        # Product specification (v1.1)
├── SOURCING_PLAYBOOK.md   # eBay sourcing prompt for finding inventory
├── LLM_HANDOFF_PROMPTS.md # Detailed implementation prompts
├── TESTING.md             # VM setup and testing workflow
├── CHANGELOG.md           # Version history
├── sync_assets.sh         # Sync ZIP assets to project
└── src/
    ├── ai_hub/            # AI Hub HTML landing page
    ├── assets/            # Branding images (wallpapers, etc.)
    ├── desktop_shortcuts/ # .desktop launchers
    ├── docs/              # User-facing documentation
    ├── firstboot/         # First boot script + systemd unit
    ├── install.sh         # Golden image installer
    ├── prompt_pack/       # Prompt Pack HTML (40+ prompts)
    ├── qa/                # QC runner script
    ├── templates/         # eBay listing template
    ├── tools/             # Python utilities
    └── welcome_center/    # Welcome Center HTML
```

## Target Hardware

- Lenovo ThinkPad T490, T480
- Dell Latitude 5400
- Intel 8th gen i5+, 8GB+ RAM, 256GB+ SSD

## Key Deliverables

1. **First Boot System**: Runs once after imaging, sets up machine identity, deploys payload, creates Timeshift snapshot
2. **Install Script**: Prepares golden image with packages and payload
3. **Welcome Center**: Simple launcher for key actions
4. **AI Hub**: One-click access to ChatGPT, Claude, Gemini
5. **Prompt Pack**: 40+ ready-to-use prompts for non-technical users
6. **QC Runner**: Automated acceptance testing
7. **Documentation**: User guides for restore, data transfer, and Linux disclosure

## Workflow

### Sourcing (Weekly)
1. Use `SOURCING_PLAYBOOK.md` prompt with Claude (web search enabled)
2. Review BUY/WATCH/REJECT recommendations
3. Purchase units that meet house spec and price ceiling

### Build Pipeline
1. Run `install.sh` on reference machine
2. Capture golden image (Clonezilla)
3. Deploy to target machines
4. First boot runs automatically, creating "Factory Fresh" snapshot
5. Run QC script, ship if PASS

### Fulfillment
1. Generate eBay listing with `generate_listing.py`
2. Include Linux disclosure insert in box
3. Ship with restore guide and data transfer guide

## License

Proprietary — Scott Orgera / Wadsworth AI PCs
