# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/).

---

## [1.0.0] - 2024-12-29

### Added

#### Core Infrastructure
- **install.sh** — Production-ready golden image installer (560+ lines)
  - Argument parsing: `--dry-run`, `--verbose`, `--help`
  - Root and OS verification (Linux Mint 22.x)
  - Package installation with verification
  - Payload deployment to `/opt/wadsworth_payload`
  - Firstboot service registration
  - Comprehensive logging to `/var/log/wadsworth/install.log`

- **firstboot.sh** — First boot personalization script (530+ lines)
  - Run-once guard with marker file
  - Machine-id and SSH key regeneration for cloned images
  - Dynamic hostname generation from DMI data
  - Payload deployment to `/opt/wadsworth`
  - Desktop shortcut deployment with trust metadata
  - Wallpaper configuration via gsettings
  - System updates (unattended)
  - Timeshift "Factory Fresh" snapshot creation
  - RustDesk verification

- **wadsworth-firstboot.service** — Systemd oneshot service for firstboot automation

#### User-Facing Components
- **AI Hub** (`ai_hub/index.html`) — Central page for AI tool access
  - Featured: ChatGPT, Claude, Gemini (prominent cards)
  - Additional: Perplexity, Microsoft Copilot, Hugging Face Chat
  - Resources section linking to Prompt Pack and AI Safety Tips
  - Tips for using AI effectively
  - Dark theme matching design system

- **Welcome Center** (`welcome_center/index.html`) — Main landing page
  - Hero section with branding
  - Quick Start: AI Hub, Prompt Pack, Start Here Guide
  - Common Tasks: Install Apps, System Updates, Backup, Printer Setup
  - Help & Support section
  - Tips for new users
  - Consistent dark theme, responsive design

- **Prompt Pack** (`prompt_pack/prompt_pack.html`) — Ready-to-use AI prompts
  - 42 prompts across 9 categories
  - Categories: Writing, Health, Finance, Home, Tech, Learning, Travel, Creative, Daily Life
  - Copy button per prompt with clipboard API
  - "Copy All" and print mode features
  - Mobile responsive, works offline

#### Desktop Shortcuts (7 files)
- `ai-hub.desktop` — Opens AI Hub
- `welcome-center.desktop` — Opens Welcome Center
- `chatgpt.desktop` — Opens ChatGPT in default browser
- `claude.desktop` — Opens Claude in default browser
- `gemini.desktop` — Opens Gemini in default browser
- `backups.desktop` — Opens Timeshift for system restore
- `browser-fix.desktop` — Opens Chromium via wrapper script

#### QA & Tooling
- **run_qc.sh** (`qa/run_qc.sh`) — Quality control script (690+ lines)
  - Hardware info collection from DMI
  - Firstboot verification
  - Payload integrity checks
  - Desktop shortcut verification
  - Application verification
  - System configuration checks
  - JSON output mode for automation
  - Exit codes: 0=PASS, 1=FAIL, 2=ERROR

- **generate_listing.py** (`tools/generate_listing.py`) — eBay listing generator
  - Reads from QC JSON or interactive input
  - Title generation with 80-character limit
  - Price calculation based on specs
  - Markdown output from template

- **ebay_listing_template.md** — Listing template with Linux disclosure

#### Documentation
- **linux_disclosure_insert.md** — Box insert for returns prevention
  - Clear "THIS IS LINUX, NOT WINDOWS" messaging
  - What works and what doesn't
  - Return policy reminder

- **wadsworth_restore_guide.md** — Timeshift restore instructions
  - Step-by-step for non-technical users
  - When to restore vs. when to contact support
  - File backup reminders

- **data_transfer_guide.md** — Moving files from Windows
  - USB drive method (recommended)
  - Cloud storage method
  - Browser bookmarks transfer
  - Email transition guidance

- **ai_safety_card.md** — What not to share with AI tools

#### Utilities
- **bin/open-chromium.sh** — Wrapper script for Chromium
  - Handles `chromium-browser` vs `chromium` package naming
  - Zenity error dialog if not installed
  - Fallback guidance for users

### Technical Details
- **Target OS:** Linux Mint Cinnamon 22.x
- **Design System:** Dark theme with CSS variables
  - `--bg-primary: #0a1929`
  - `--accent: #66b2ff`
  - Consistent across AI Hub, Welcome Center, Prompt Pack
- **All HTML:** Self-contained, no external dependencies, works offline
- **All scripts:** `set -euo pipefail`, support `--dry-run` and `--verbose`
- **Payload path:** `/opt/wadsworth` (deployed), `/opt/wadsworth_payload` (staging)

---

## [Unreleased]

### Added
- TESTING.md — VM setup guide and testing workflow (UTM + Ubuntu ARM64)
- SOURCING_PLAYBOOK.md — eBay sourcing prompt for finding inventory
- LLM_HANDOFF_PROMPTS.md with detailed prompts for Claude Code
- sync_assets.sh helper script to sync ZIP assets to project
- .claude/PROJECT_INSTRUCTIONS.md for Claude Project setup

### Changed
- Updated REQUIREMENTS.md to v1.1 with new deliverables
- Updated TODO.md with Phase 0 (setup) and Phase 5 (printed materials)
- Expanded Prompt Pack requirement from 30 to 40+ prompts

---

## [0.1.0] - 2024-12-22

### Added
- Initial project structure
- AGENTS.md — Agent roles and workflow definition
- SKILLS.md — Linux Mint technical knowledge base
- TODO.md — Task backlog with phases
- README.md — Project overview
- REQUIREMENTS.md — Product specification (from handoff pack v1.1)

### Included from Handoff Pack
- Skeleton firstboot.sh
- Skeleton install.sh
- Skeleton welcome_center/index.html
- Skeleton ai_hub/index.html
- Skeleton prompt_pack/prompt_pack.html
- Desktop shortcuts (.desktop files)
- Documentation templates
- eBay listing template

### Notes
- Assets (PNG wallpapers, etc.) need to be synced from ZIP
- All implementation tasks marked as not started
